unit logFile;

interface

uses System.IO, System.Globalization;

type PlikRejestrowania = class
  public
    constructor Create(nazwaPliku: String);
    procedure Dopisz(tekst: String);
  private
    nazwaPliku: String;
    uzytkownik: String;
end;

implementation

constructor PlikRejestrowania.Create(nazwaPliku: String);
begin
inherited Create;
Self.nazwaPliku:=nazwaPliku;
Self.uzytkownik:=Environment.get_UserName;
end;

procedure PlikRejestrowania.Dopisz(tekst: String);
var sw: StreamWriter;
    czasZapisu: String;
begin
  czasZapisu:=DateTime.Now.ToString;
  sw:=System.IO.File.AppendText(nazwaPliku);
  sw.WriteLine(czasZapisu+' '+tekst+' uzytkownik:'+uzytkownik);
  sw.Close;
end;

end.
